import Stripe from './Stripe';

const ENQUEUED_NONE = 'NONE';
const ENQUEUED_GAP = 'GAP';

class StripeBuilder {
  timestamps = [];

  highs = [];

  lows = [];

  size = 0;

  enqueued = ENQUEUED_NONE;

  enqueuedTs;

  isEmpty() {
    return this.size === 0;
  }

  addRealPoint(ts, high, low) {
    if (isNaN(high)) {
      throw new Error('high is NaN');
    }

    if (isNaN(low)) {
      throw new Error('low is NaN');
    }

    if (this.enqueued === ENQUEUED_GAP) {
      if (this.size !== 0) {
        this.addRaw(this.enqueuedTs, NaN, NaN);
      }
      this.enqueued = ENQUEUED_NONE;
      this.enqueuedTs = 0;
    }

    if (this.size > 0
      && this.timestamps[this.size - 1] === ts
      && this.highs[this.size - 1] === high
      && this.lows[this.size - 1] === low) {
      // no need to add identical point
      return;
    }

    this.addRaw(ts, high, low);
  }

  addRaw(ts, high, low) {
    this.timestamps[this.size] = ts;
    this.highs[this.size] = high;
    this.lows[this.size] = low;
    // eslint-disable-next-line no-plusplus
    ++this.size;
  }

  enqueueGap(ts) {
    // do not overwrite ts
    if (this.enqueued === ENQUEUED_GAP) {
      return;
    }

    this.enqueued = ENQUEUED_GAP;
    this.enqueuedTs = ts;
  }

  build() {
    return new Stripe(
      [...this.timestamps],
      [...this.highs],
      [...this.lows],
    );
  }
}

export default StripeBuilder;
