/* eslint-disable no-plusplus */
class TimelineNavigator {
  pos;

  scrolledToMillis;

  constructor(timestamps) {
    this.timestamps = timestamps;
    this.pos = 0;
    this.scrolledToMillis = 0;
  }

  scrollBackwardMillis(millis) {
    for (; ;) {
      if (this.pos === 0) {
        break;
      }
      if (this.timestamps[this.pos - 1] < millis) {
        break;
      }
      --this.pos;
    }

    this.scrolledToMillis = millis;
  }

  scrollForwardMillis(millis) {
    for (; ;) {
      if (this.pos === this.timestamps.length - 1) {
        break;
      }
      if (this.timestamps[this.pos + 1] > millis) {
        break;
      }
      ++this.pos;
    }

    this.scrolledToMillis = millis;
  }

  scrollToMillis(millis) {
    if (this.timestamps.length === 0) {
      this.scrolledToMillis = millis;
      return;
    }

    if (millis < this.scrolledToMillis) {
      this.scrollBackwardMillis(millis);
    } else {
      this.scrollForwardMillis(millis);
    }
  }

  getPos() {
    return this.pos;
  }

  isOnPoint() {
    return this.timestamps.length !== 0 && this.timestamps[this.pos] === this.scrolledToMillis;
  }

  isBetweenPoints() {
    if (this.timestamps.length === 0) {
      return false;
    }
    if (this.isOnPoint()) {
      return false;
    }
    if (this.pos === 0 && this.scrolledToMillis < this.timestamps[0]) {
      return false;
    }
    return this.pos < this.timestamps.length - 1;
  }
}

export default TimelineNavigator;
