/* eslint-disable no-plusplus */
import isEqual from 'lodash/isEqual';
import flatMap from 'lodash/flatMap';
import uniq from 'lodash/uniq';

class TimelineUtils {
  /**
   * @param {Timeline} a
   * @param {Timeline} b
   * @return {Timeline}
   */
  static unionTwo(a, b) {
    if (a.length === 0) {
      return b;
    }
    if (b.length === 0) {
      return a;
    }

    if (isEqual(a, b)) {
      return a;
    }

    return TimelineUtils.union([a, b]);
  }

  static union(timelines) {
    if (timelines.length === 0) {
      return [];
    }

    if (timelines.length === 1) {
      return timelines[0];
    }

    let timestamps = flatMap(timelines, (t) => t);
    timestamps.sort();
    timestamps = uniq(timestamps);
    return timestamps;
  }

  /**
   * @param {Timeline} a
   * @param {Timeline} b
   * @param {function} visitLeft
   * @param {function} visitRight
   * @param {function} visitBoth
   */
  static visitCommonTimeline(a, b, visitLeft, visitRight, visitBoth) {
    let ai = 0;
    let bi = 0;
    while (ai < a.length && bi < b.length) {
      const at = a[ai];
      const bt = b[bi];

      if (at === bt) {
        visitBoth(at, ai, bi);
        ++ai;
        ++bi;
      } else if (at < bt) {
        visitLeft(at, ai);
        ++ai;
      } else {
        visitRight(bt, bi);
        ++bi;
      }
    }

    while (ai < a.length) {
      const at = a[ai];
      visitLeft(at, ai);
      ++ai;
    }
    while (bi < b.length) {
      const bt = b[bi];
      visitRight(bt, bi);
      ++bi;
    }
  }
}

export default TimelineUtils;
