class Triples {
  constructor(lefts, middles, rights) {
    this.lefts = lefts;
    this.middles = middles;
    this.rights = rights;
  }

  static forSize(size) {
    const lefts = new Array(size).fill(0);
    const middles = new Array(size).fill(0);
    const rights = new Array(size).fill(0);
    return new Triples(lefts, middles, rights);
  }

  getLefts() {
    return this.lefts;
  }

  getMiddles() {
    return this.middles;
  }

  getRights() {
    return this.rights;
  }

  mapValues(op) {
    const lefts = this.lefts.map(op);
    const middles = this.middles.map(op);
    const rights = this.rights.map(op);
    return new Triples(lefts, middles, rights);
  }
}

export default Triples;
