import * as TimeUnit from './TimeUnit';

class StepUnit {
  static RANGES = [
    new StepUnit(TimeUnit.MINUTE_MILLIS, 1),
    new StepUnit(TimeUnit.MINUTE_MILLIS, 2),
    new StepUnit(TimeUnit.MINUTE_MILLIS, 5),
    new StepUnit(TimeUnit.MINUTE_MILLIS, 15),
    new StepUnit(TimeUnit.MINUTE_MILLIS, 30),
    new StepUnit(TimeUnit.HOUR_MILLIS, 1),
    new StepUnit(TimeUnit.HOUR_MILLIS, 2),
    new StepUnit(TimeUnit.HOUR_MILLIS, 4),
    new StepUnit(TimeUnit.HOUR_MILLIS, 12),
    new StepUnit(TimeUnit.DAY_MILLIS, 1),
    new StepUnit(TimeUnit.DAY_MILLIS, 2),
    new StepUnit(TimeUnit.WEEK_MILLIS, 1),
    new StepUnit(TimeUnit.WEEK_MILLIS, 2),
    new StepUnit(TimeUnit.MONTH_MILLIS, 1),
    new StepUnit(TimeUnit.MONTH_MILLIS, 2),
    new StepUnit(TimeUnit.MONTH_MILLIS, 4),
    new StepUnit(TimeUnit.YEAR_MILLIS, 1),
  ];

  constructor(type, multiplier) {
    this.type = type;
    this.multiplier = multiplier;
  }

  getType() {
    return this.type;
  }

  getMultiplier() {
    return this.multiplier;
  }

  static forDuration(duration) {
    for (let i = 0; i < StepUnit.RANGES.length; ++i) {
      const range = StepUnit.RANGES[i];
      if (range.type * range.multiplier >= duration) {
        return range;
      }
    }

    return new StepUnit(TimeUnit.YEAR_MILLIS, 1);
  }

  static forInterval(interval, maxXTicks) {
    const durationMillis = interval.end.getTime() - interval.begin.getTime();
    const maxGridDurationMillis = maxXTicks === 0 ? durationMillis : durationMillis / maxXTicks;
    return StepUnit.forDuration(maxGridDurationMillis);
  }
}

export default StepUnit;
