import {
  DAY_MILLIS,
  HOUR_MILLIS,
  MINUTE_MILLIS,
  MONTH_MILLIS,
  WEEK_MILLIS,
  YEAR_MILLIS,
} from './TimeUnit';

class TickFormatter {
  static MONTH_NAMES = [
    'Jan', 'Feb',
    'Mar', 'Apr', 'May',
    'Jun', 'Jul', 'Aug',
    'Sep', 'Oct', 'Nov',
    'Dec',
  ];

  static formatMonthDay(date) {
    let sb = '';
    sb += TickFormatter.MONTH_NAMES[date.getMonth()];
    sb += ' ';
    if (date.getDate() < 10) {
      sb += '0';
    }
    sb += date.getDate();
    return sb;
  }

  static formatTime(date) {
    let sb = '';
    if (date.getHours() < 10) {
      sb += '0';
    }
    sb += date.getHours();
    sb += ':';
    if (date.getMinutes() < 10) {
      sb += '0';
    }
    sb += date.getMinutes();
    return sb;
  }

  static tickLabel(date, timeUnit) {
    switch (timeUnit) {
      case YEAR_MILLIS:
        return `${date.getFullYear()}`;
      case MONTH_MILLIS:
        return TickFormatter.MONTH_NAMES[date.getMonth()];
      case DAY_MILLIS:
      case WEEK_MILLIS:
        return TickFormatter.formatMonthDay(date);
      case HOUR_MILLIS:
      case MINUTE_MILLIS:
        if (date.getSeconds() === 0 && date.getMinutes() === 0 && date.getHours() === 0) {
          return TickFormatter.formatMonthDay(date);
        }

        return TickFormatter.formatTime(date);
      default:
        throw new Error(`unknown time unit: ${timeUnit}`);
    }
  }
}

export default TickFormatter;
