/* eslint-disable no-param-reassign */
import { DAY_MILLIS, WEEK_MILLIS } from './TimeUnit';
import { SATURDAY, SUNDAY } from './DayOfWeek';

class Weekends {
  /**
   * @param {Date} date
   * @param {number} dayOfWeek
   * @return {Date}
   */
  static prevDayOfWeek(date, dayOfWeek) {
    while (date.getDay() !== dayOfWeek) {
      date = new Date(date.getTime() - DAY_MILLIS);
    }
    return new Date(date.getFullYear(), date.getMonth(), date.getDate());
  }

  static nextDayOfWeek(date, dayOfWeek) {
    while (date.getDay() !== dayOfWeek) {
      date = new Date(date.getTime() + DAY_MILLIS);
    }
    return new Date(date.getFullYear(), date.getMonth(), date.getDate());
  }

  static weekendsIntersectingInterval(interval) {
    const r = [];

    let holidayBegin;
    const day = interval.begin.getDay();
    if (day === SATURDAY || day === SUNDAY) {
      holidayBegin = Weekends.prevDayOfWeek(interval.begin, SATURDAY);
    } else {
      holidayBegin = Weekends.nextDayOfWeek(interval.begin, SATURDAY);
    }

    while (holidayBegin.getTime() < interval.end.getTime()) {
      const holidayEnd = new Date(holidayBegin.getTime() + (2 * DAY_MILLIS));

      r.push({ begin: holidayBegin, end: holidayEnd });

      holidayBegin = new Date(holidayBegin.getTime() + WEEK_MILLIS);
    }

    return r;
  }
}

export default Weekends;
