import * as DayOfWeek from './DayOfWeek';
import { DAY_MILLIS, WEEK_MILLIS } from './TimeUnit';

class Weeks {
  /**
   * @param {Date} date
   * @return {Date}
   */
  static firstMonday(date) {
    let tempDate = date;
    while (tempDate.getDay() !== DayOfWeek.MONDAY) {
      tempDate = new Date(tempDate.getTime() + DAY_MILLIS);
    }
    return tempDate;
  }

  /**
   *
   * @param date
   * @param multiplier
   * @return {*}
   */
  static roundToWeekStart(date, multiplier) {
    const yearMonth = new Date(date.getFullYear(), date.getMonth());
    let firstMondayDate = Weeks.firstMonday(yearMonth);

    while (date.getTime() >= firstMondayDate.getTime()) {
      firstMondayDate = new Date(firstMondayDate.getTime() + (multiplier * WEEK_MILLIS));
    }

    return new Date(firstMondayDate.getTime() - (multiplier * WEEK_MILLIS));
  }
}

export default Weeks;
