import TicksMaker from './TicksMaker';
import TickFormatter from './TickFormatter';

class Xaxis {
  static makeTicks(interval, stepUnit) {
    const tickMarks = TicksMaker.tickMarks(interval, stepUnit);
    return tickMarks.map((date) => [
      date.getTime() / 1000,
      TickFormatter.tickLabel(date, stepUnit.getType()),
    ]);
  }
}

export default Xaxis;
