import * as Redux from 'redux';
import thunk from 'redux-thunk';
import appReducer from './reducers';

export default function createStore() {
  const devtools = window.__REDUX_DEVTOOLS_EXTENSION__
    ? window.__REDUX_DEVTOOLS_EXTENSION__()
    : (fn) => fn;

  const store = Redux.createStore(
    appReducer,
    Redux.compose(
      Redux.applyMiddleware(thunk),
      devtools,
    ),
  );

  return store;
}

export const store = createStore();
