import * as API from '../../../api/alerts';
import { addDangerAlert } from '../toaster';

const LOAD_ALERT_EVAL_STATE = 'LOAD_ALERT_EVAL_STATE';

// eslint-disable-next-line max-len
export const loadAlertEvalState = (projectId, alertId) => (dispatch) => API.fetchAlertEvalState(projectId, alertId)
  .then(
    (resp) => dispatch({ type: LOAD_ALERT_EVAL_STATE, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const alertEvalStateReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_ALERT_EVAL_STATE:
      return action.payload;
    default:
      return state;
  }
};
