import * as API from '../../../api/alerts';
import { addDangerAlert } from '../toaster';

const LOAD_ALERT_EVAL_STATS = 'LOAD_ALERT_EVAL_STATS';

// eslint-disable-next-line max-len
export const loadAlertEvalStats = (projectId, alertId) => (dispatch) => API.fetchAlertEvalStats(projectId, alertId)
  .then(
    (resp) => dispatch({ type: LOAD_ALERT_EVAL_STATS, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const alertEvalStatsReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_ALERT_EVAL_STATS:
      return action.payload;
    default:
      return state;
  }
};
