import * as API from '../../../api/alerts';

const START_TO_EXPLAIN_ALERT = 'START_TO EXPLAIN_ALERT';
const FINISH_TO_EXPLAIN_ALERT = 'FINISH_TO EXPLAIN_ALERT';
const CLEAR_ALERT_EXPLANATION = 'CLEAR_ALERT_EXPLANATION';

export const explainAlert = (projectId, alert) => (dispatch) => {
  dispatch({ type: START_TO_EXPLAIN_ALERT });

  return API.explainAlert(projectId, alert)
    .then((resp) => dispatch({
      type: FINISH_TO_EXPLAIN_ALERT,
      payload: resp,
    }),
    (resp) => dispatch({
      type: FINISH_TO_EXPLAIN_ALERT,
      payload: {
        status: {
          code: 'ERROR',
          description: resp.message,
          annotations: null,
        },
      },
    }));
};

// eslint-disable-next-line max-len
export const clearAlertExplanation = () => (dispatch) => dispatch({ type: CLEAR_ALERT_EXPLANATION });

const DEFAULT_STATE = {};

const ALERT_EXPLANATION_LOADING_STATE = {
  loading: true,
  data: null,
};

export const alertExplanationReducer = (state = DEFAULT_STATE, action) => {
  switch (action.type) {
    case START_TO_EXPLAIN_ALERT:
      return ALERT_EXPLANATION_LOADING_STATE;
    case FINISH_TO_EXPLAIN_ALERT:
      return { loading: false, data: action.payload };
    case CLEAR_ALERT_EXPLANATION:
      return DEFAULT_STATE;
    default:
      return state;
  }
};
