import * as API from '../../../api/alerts';
import { addDangerAlert } from '../toaster';

const LOAD_ALERT_NOTIFICATION_STATE = 'LOAD_ALERT_NOTIFICATION_STATE';

// eslint-disable-next-line max-len
export const loadAlertNotificationState = (projectId, alertId) => (dispatch) => API.fetchAlertNotificationState(projectId, alertId)
  .then(
    (resp) => dispatch({ type: LOAD_ALERT_NOTIFICATION_STATE, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const alertNotificationStateReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_ALERT_NOTIFICATION_STATE:
      return action.payload;
    default:
      return state;
  }
};
