import * as API from '../../../api/alerts';

const LOAD_ALERT_NOTIFICATION_STATS = 'LOAD_ALERT_NOTIFICATION_STATS';

export const loadAlertNotificationStats = (projectId, alertId) => (dispatch) =>
  API.fetchAlertNotificationStats(projectId, alertId)
    .then((resp) => dispatch({ type: LOAD_ALERT_NOTIFICATION_STATS, payload: resp }));

export const alertNotificationStatsReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_ALERT_NOTIFICATION_STATS:
      return action.payload;
    default:
      return state;
  }
};
