import * as API from '../../../api/alerts';
import { addDangerAlert } from '../toaster';

const LOAD_PROJECT_ALERTS = 'LOAD_PROJECT_ALERTS';
const LOAD_NEXT_PROJECT_ALERTS = 'LOAD_NEXT_PROJECT_ALERTS';
const CLEAR_PROJECT_ALERTS = 'CLEAR_PROJECT_ALERTS';

export const loadProjectAlerts = (projectId, params) => (dispatch) =>
  API.fetchAlerts(projectId, params)
    .then(
      (resp) => dispatch({ type: LOAD_PROJECT_ALERTS, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const loadNextProjectAlerts = (projectId, params) => (dispatch) =>
  API.fetchAlerts(projectId, params)
    .then(
      (resp) => dispatch({ type: LOAD_NEXT_PROJECT_ALERTS, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearProjectAlerts = () => (dispatch) => dispatch({ type: CLEAR_PROJECT_ALERTS });

export const alertsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_PROJECT_ALERTS:
      return action.payload;
    case LOAD_NEXT_PROJECT_ALERTS:
      return { ...action.payload, items: [...state.items, ...action.payload.items] };
    case CLEAR_PROJECT_ALERTS:
      return {};
    default:
      return state;
  }
};
