import * as API from '../../../api/alerts';
import { addDangerAlert } from '../toaster';

const LOAD_TEMPLATES = 'LOAD_TEMPLATES';
const LOAD_DEFAULT_TEMPLATES = 'LOAD_DEFAULT_TEMPLATES';
const LOAD_NEXT_TEMPLATES = 'LOAD_NEXT_TEMPLATES';
const CLEAR_TEMPLATES = 'CLEAR_TEMPLATES';

export const loadTemplates = (params) => (dispatch) =>
  API.fetchAlertTemplates(params)
    .then(
      (resp) => dispatch({ type: LOAD_TEMPLATES, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const loadDefaultTemplates = (params) => (dispatch) =>
  API.fetchAlertTemplates(params)
    .then(
      (resp) => dispatch(
        {
          type: LOAD_DEFAULT_TEMPLATES,
          payload: {
            items: resp.items.filter((item) => item.isDefaultTemplate),
          },
        },
      ),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const loadNextTemplates = (params) => (dispatch) =>
  API.fetchAlertTemplates(params)
    .then(
      (resp) => dispatch({ type: LOAD_NEXT_TEMPLATES, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearTemplates = () => (dispatch) => dispatch({ type: CLEAR_TEMPLATES });

export const alertsTemplatesPageReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_TEMPLATES:
      return action.payload;
    case LOAD_DEFAULT_TEMPLATES:
      return action.payload;
    case LOAD_NEXT_TEMPLATES:
      return { ...action.payload, items: [...state.items, ...action.payload.items] };
    case CLEAR_TEMPLATES:
      return {};
    default:
      return state;
  }
};
