import * as API from '../../../api/alerts';

const START_TO_LOAD_EXISTING_ALERT_EXPLANATION_STATE = 'START_TO_LOAD_EXISTING_ALERT_EXPLANATION';
const FINISH_TO_LOAD_EXISTING_ALERT_EXPLANATION_STATE = 'FINISH_TO_LOAD_EXISTING_ALERT_EXPLANATION';
const CLEAR_EXISTING_ALERT_EXPLANATION_STATE = 'CLEAR_EXISTING_ALERT_EXPLANATION';

export const loadExistingAlertExplanation = (projectId, alertId, urlParams) => (dispatch) => {
  dispatch({
    type: START_TO_LOAD_EXISTING_ALERT_EXPLANATION_STATE,
  });

  return API.fetchExistingAlertExplanation(projectId, alertId, urlParams)
    .then((resp) => dispatch({
      type: FINISH_TO_LOAD_EXISTING_ALERT_EXPLANATION_STATE,
      payload: resp,
    }),
    (resp) => dispatch({
      type: FINISH_TO_LOAD_EXISTING_ALERT_EXPLANATION_STATE,
      payload: {
        status: {
          code: 'ERROR',
          description: resp.message,
          annotations: null,
        },
      },
    }));
};

const DEFAULT_STATE = {};
const LOADING_STATE = { loading: true, data: {} };

export const existingAlertExplanationReducer = (state = DEFAULT_STATE, action) => {
  switch (action.type) {
    case START_TO_LOAD_EXISTING_ALERT_EXPLANATION_STATE:
      return LOADING_STATE;
    case FINISH_TO_LOAD_EXISTING_ALERT_EXPLANATION_STATE:
      return { loading: false, data: action.payload };
    case CLEAR_EXISTING_ALERT_EXPLANATION_STATE:
      return DEFAULT_STATE;
    default:
      return state;
  }
};
