import * as API from '../../../api/alerts';

const LOAD_PROJECT_ALERT_STATS = 'LOAD_PROJECT_ALERT_STATS';
const CLEAR_PROJECT_ALERT_STATS = 'CLEAR_PROJECT_ALERT_STATS';

export const loadProjectAlertStats = (projectId) => (dispatch) =>
  API.fetchProjectAlertStats(projectId)
    .then(
      (resp) => dispatch({ type: LOAD_PROJECT_ALERT_STATS, payload: resp }),
      () => dispatch({ type: LOAD_PROJECT_ALERT_STATS, payload: {} }),
    );

export const clearProjectAlertStats = () => (dispatch) =>
  dispatch({ type: CLEAR_PROJECT_ALERT_STATS });

export const projectAlertStatsReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_PROJECT_ALERT_STATS:
      return action.payload;
    case CLEAR_PROJECT_ALERT_STATS:
      return {};
    default:
      return state;
  }
};
