import * as API from '../../../api/alerts';
import { addDangerAlert } from '../toaster';

const LOAD_SUBALERT = 'LOAD_SUBALERT';
const CLEAR_SUBALERT = 'CLEAR_SUBALERT';

export const loadSubAlert = (projectId, alertId, subAlertId) => (dispatch) =>
  API.fetchSubAlert(projectId, alertId, subAlertId)
    .then(
      (resp) => dispatch({ type: LOAD_SUBALERT, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearSubAlert = () => (dispatch) => dispatch({ type: CLEAR_SUBALERT });

export const subAlertReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_SUBALERT:
      return action.payload;
    case CLEAR_SUBALERT:
      return {};
    default:
      return state;
  }
};
