import * as API from '../../../api/alerts';
import { addDangerAlert } from '../toaster';

const LOAD_SUBALERT_EVAL_STATE = 'LOAD_SUBALERT_EVAL_STATE';
const CLEAR_SUBALERT_EVAL_STATE = 'CLEAR_SUBALERT_EVAL_STATE';

export const loadSubAlertEvalState = (projectId, alertId, subAlertId) => (dispatch) =>
  API.fetchSubAlertEvaluationState(projectId, alertId, subAlertId)
    .then(
      (resp) => dispatch({ type: LOAD_SUBALERT_EVAL_STATE, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearSubAlertEvalState = () => (dispatch) =>
  dispatch({ type: CLEAR_SUBALERT_EVAL_STATE });

export const subAlertEvalStateReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_SUBALERT_EVAL_STATE:
      return action.payload;
    case CLEAR_SUBALERT_EVAL_STATE:
      return {};
    default:
      return state;
  }
};
