import * as API from '../../../api/alerts';

const START_TO_LOAD_SUBALERT_EXPLANATION_STATE = 'START_TO_LOAD_SUBALERT_EXPLANATION_STATE';
const FINISH_TO_LOAD_SUBALERT_EXPLANATION_STATE = 'FINISH_TO_LOAD_SUBALERT_EXPLANATION_STATE';
const CLEAR_SUBALERT_EXPLANATION_STATE = 'CLEAR_SUBALERT_EXPLANATION_STATE';

// eslint-disable-next-line max-len
export const loadExistingSubAlertExplanation = (projectId, alertId, subAlertId, urlParams) => (dispatch) => {
  dispatch({ type: START_TO_LOAD_SUBALERT_EXPLANATION_STATE });

  return API.fetchExistingSubAlertExplanation(projectId, alertId, subAlertId, urlParams)
    .then((resp) => dispatch({
      type: FINISH_TO_LOAD_SUBALERT_EXPLANATION_STATE,
      payload: resp,
    }),
    (resp) => dispatch({
      type: FINISH_TO_LOAD_SUBALERT_EXPLANATION_STATE,
      payload: {
        status: {
          code: 'ERROR',
          description: resp.message,
          annotations: null,
        },
      },
    }));
};

const DEFAULT_STATE = {};

export const subAlertExplanationReducer = (state = DEFAULT_STATE, action) => {
  switch (action.type) {
    case START_TO_LOAD_SUBALERT_EXPLANATION_STATE:
      return { loading: true, data: {} };
    case FINISH_TO_LOAD_SUBALERT_EXPLANATION_STATE:
      return { loading: false, data: action.payload };
    case CLEAR_SUBALERT_EXPLANATION_STATE:
      return DEFAULT_STATE;
    default:
      return state;
  }
};
