import * as API from '../../../api/alerts';
import { addDangerAlert } from '../toaster';

const LOAD_SUBALERT_NOTIFICATION_STATE = 'LOAD_SUBALERT_NOTIFICATION_STATE';
const CLEAR_SUBALERT_NOTIFICATION_STATE = 'CLEAR_SUBALERT_NOTIFICATION_STATE';

export const loadSubAlertNotificationState = (projectId, alertId, subAlertId) => (dispatch) =>
  API.fetchSubAlertNotificationState(projectId, alertId, subAlertId)
    .then(
      (resp) => dispatch({ type: LOAD_SUBALERT_NOTIFICATION_STATE, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearSubAlertNotificationState = () => (dispatch) =>
  dispatch({ type: CLEAR_SUBALERT_NOTIFICATION_STATE });

export const subAlertNotificationStateReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_SUBALERT_NOTIFICATION_STATE:
      return action.payload;
    case CLEAR_SUBALERT_NOTIFICATION_STATE:
      return {};
    default:
      return state;
  }
};
