import * as API from '../../../api/alerts';
import { addDangerAlert } from '../toaster';

const LOAD_SUBALERTS = 'LOAD_SUBALERTS';
const LOAD_NEXT_SUBALERTS = 'LOAD_NEXT_SUBALERTS';
const CLEAR_SUBALERTS = 'CLEAR_SUBALERTS';

export const loadSubAlerts = (projectId, alertId, params) => (dispatch) =>
  API.fetchSubAlerts(projectId, alertId, params)
    .then(
      (resp) => dispatch({ type: LOAD_SUBALERTS, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const loadNextSubAlerts = (projectId, alertId, params) => (dispatch) =>
  API.fetchSubAlerts(projectId, alertId, params)
    .then(
      (resp) => dispatch({ type: LOAD_NEXT_SUBALERTS, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearSubAlerts = () => (dispatch) => dispatch({ type: CLEAR_SUBALERTS });

export const subAlertsReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_SUBALERTS:
      return action.payload;
    case LOAD_NEXT_SUBALERTS:
      return { ...action.payload, items: [...state.items, ...action.payload.items] };
    case CLEAR_SUBALERTS:
      return {};
    default:
      return state;
  }
};
