import * as API from '../../../api/telegram';
import { addDangerAlert } from '../toaster';

const TELEGRAM_GROUP_TITLES_FOUND = 'TELEGRAM_GROUP_TITLES_FOUND';

export const findTelegramGroupTitles = () => (dispatch) => API.fetchGroupTitles()
  .then(
    (resp) => dispatch({ type: TELEGRAM_GROUP_TITLES_FOUND, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const telegramGroupTitlesReducer = (state = [], action) => {
  switch (action.type) {
    case TELEGRAM_GROUP_TITLES_FOUND:
      return action.payload;
    default:
      return state;
  }
};
