import * as API from '../../../api/yaChats';
import { addDangerAlert } from '../toaster';

const YA_CHATS_GROUP_IDS_FOUND = 'YA_CHATS_GROUP_IDS_FOUND';

export const findYaChatsGroupIds = () => (dispatch) => API.fetchGroupIds()
  .then(
    (resp) => dispatch({ type: YA_CHATS_GROUP_IDS_FOUND, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const yaChatsGroupIdsReducer = (state = [], action) => {
  switch (action.type) {
    case YA_CHATS_GROUP_IDS_FOUND:
      return action.payload;
    default:
      return state;
  }
};
