import * as API from '../../../api/channels';
import { addDangerAlert } from '../toaster';

const CHANNEL_FOUND = 'NOTIFICATION_CHANNEL_FOUND';
const CHANNEL_SAVED = 'NOTIFICATION_CHANNEL_SAVED';
const CHANNEL_DELETED = 'NOTIFICATION_CHANNEL_DELETED';
const CHANNEL_CLEARED = 'NOTIFICATION_CHANNEL_CLEARED';

export const findChannel = (projectId, channelId) => (dispatch) =>
  API.fetchChannel(projectId, channelId)
    .then(
      (resp) => dispatch({ type: CHANNEL_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const saveChannel = (projectId, channel, isNew) => (dispatch) => {
  const promise = isNew
    ? API.createChannel(projectId, channel)
    : API.updateChannel(projectId, channel);

  promise
    .then(
      (resp) => dispatch({ type: CHANNEL_SAVED, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

  return promise;
};

export const deleteChannel = (projectId, channelId) => (dispatch) =>
  API.deleteChannel(projectId, channelId)
    .then(
      (resp) => dispatch({ type: CHANNEL_DELETED, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearChannel = () => (dispatch) => dispatch({ type: CHANNEL_CLEARED });

export const channelReducer = (state = {}, action) => {
  switch (action.type) {
    case CHANNEL_FOUND:
      return action.payload;
    case CHANNEL_SAVED:
    case CHANNEL_DELETED:
    case CHANNEL_CLEARED:
      return {};
    default:
      return state;
  }
};
