import * as API from '../../../api/alerts';
import { addDangerAlert } from '../toaster';

const LOAD_CHANNEL_ALERTS = 'LOAD_CHANNEL_ALERTS';
const LOAD_NEXT_CHANNEL_ALERTS = 'LOAD_NEXT_CHANNEL_ALERTS';
const CLEAR_CHANNEL_ALERTS = 'CLEAR_CHANNEL_ALERTS';

export const loadChannelAlerts = (projectId, channelId, params) => (dispatch) =>
  API.fetchAlerts(projectId, { filterByNotificationId: channelId, ...params })
    .then(
      (resp) => dispatch({ type: LOAD_CHANNEL_ALERTS, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const loadNextChannelAlerts = (projectId, channelId, params) => (dispatch) =>
  API.fetchAlerts(projectId, { filterByNotificationId: channelId, ...params })
    .then(
      (resp) => dispatch({ type: LOAD_NEXT_CHANNEL_ALERTS, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearChannelAlerts = () => (dispatch) => dispatch({ type: CLEAR_CHANNEL_ALERTS });

export const channelAlertsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_CHANNEL_ALERTS:
      return action.payload;
    case LOAD_NEXT_CHANNEL_ALERTS:
      return { ...action.payload, items: [...state.items, ...action.payload.items] };
    case CLEAR_CHANNEL_ALERTS:
      return {};
    default:
      return state;
  }
};
