import * as API from '../../../api/channels';
import { addDangerAlert } from '../toaster';

const PROJECT_CHANNELS_FOUND = 'NOTIFICATION_CHANNELS_FOUND';
const NEXT_PROJECT_CHANNELS_FOUND = 'NEXT_NOTIFICATION_CHANNELS_FOUND';

export const findProjectChannels = (projectId, params) => (dispatch) =>
  API.fetchChannels(projectId, params)
    .then(
      (resp) => dispatch({ type: PROJECT_CHANNELS_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const findNextProjectChannels = (projectId, params) => (dispatch) =>
  API.fetchChannels(projectId, params)
    .then(
      (resp) => dispatch({ type: NEXT_PROJECT_CHANNELS_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const channelsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case PROJECT_CHANNELS_FOUND:
      return action.payload;
    case NEXT_PROJECT_CHANNELS_FOUND:
      return { ...action.payload, items: [...state.items, ...action.payload.items] };
    default:
      return state;
  }
};
