import * as API from '../../../api/clusters';
import { addDangerAlert } from '../toaster';

const CLUSTER_FOUND = 'CLUSTER_FOUND';
const CLUSTER_SAVED = 'CLUSTER_SAVED';
const CLUSTER_DELETED = 'CLUSTER_DELETED';
const CLUSTER_CLEAR = 'CLUSTER_CLEAR';

export const findCluster = (projectId, clusterId) => (dispatch) =>
  API.fetchCluster(projectId, clusterId)
    .then(
      (resp) => dispatch({ type: CLUSTER_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const saveCluster = (projectId, cluster, isNew) => (dispatch) => {
  const promise = isNew
    ? API.createCluster(projectId, cluster)
    : API.updateCluster(projectId, cluster);
  promise.then(
    () => dispatch({ type: CLUSTER_SAVED }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );
  return promise;
};

export const deleteCluster = (projectId, clusterId) => (dispatch) =>
  API.deleteCluster(projectId, clusterId)
    .then(
      () => dispatch({ type: CLUSTER_DELETED }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearCluster = () => (dispatch) => dispatch({ type: CLUSTER_CLEAR });

export const clusterReducer = (state = {}, action) => {
  switch (action.type) {
    case CLUSTER_FOUND:
      return action.payload;
    case CLUSTER_SAVED:
    case CLUSTER_DELETED:
    case CLUSTER_CLEAR:
      return {};
    default:
      return state;
  }
};
