import * as API from '../../../api/clusters';
import { addDangerAlert } from '../toaster';

const CLUSTER_SERVICES_FOUND = 'CLUSTER_SERVICES_FOUND';

export const findClusterServices = (projectId, clusterId) => (dispatch) =>
  API.fetchClusterServices(projectId, clusterId)
    .then(
      (resp) => dispatch({ type: CLUSTER_SERVICES_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clusterServicesReducer = (state = [], action) => {
  switch (action.type) {
    case CLUSTER_SERVICES_FOUND:
      return action.payload;
    default:
      return state;
  }
};
