import { addDangerAlert } from '../toaster';
import * as API from '../../../api/clusters';

const CLUSTERS_FOUND = 'CLUSTERS_FOUND';

export const findProjectClusters = (projectId, params) => (dispatch) =>
  API.fetchProjectClusters(projectId, params)
    .then(
      (resp) => dispatch({ type: CLUSTERS_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clustersPageReducer = (state = {}, action) => {
  switch (action.type) {
    case CLUSTERS_FOUND:
      return action.payload;
    default:
      return state;
  }
};
