import * as API from '../../../api/clusters';
import { addDangerAlert } from '../toaster';

const START_TO_LOAD_GLOBAL_CLUSTERS = 'START_TO_LOAD_GLOBAL_CLUSTERS';
const FINISH_TO_LOAD_GLOBAL_CLUSTERS = 'FINISH_TO_LOAD_GLOBAL_CLUSTERS';
const FAILED_TO_LOAD_GLOBAL_CLUSTERS = 'FAILED_TO_LOAD_GLOBAL_CLUSTERS';
const CLEAR_GLOBAL_CLUSTERS = 'CLEAR_GLOBAL_SERVICES';

export const findGlobalClusters = (params) => (dispatch) => {
  dispatch({ type: START_TO_LOAD_GLOBAL_CLUSTERS });

  return API.fetchGlobalClusters(params)
    .then(
      (resp) => dispatch({ type: FINISH_TO_LOAD_GLOBAL_CLUSTERS, payload: resp }),
      (resp) => {
        dispatch({ type: FAILED_TO_LOAD_GLOBAL_CLUSTERS, payload: resp });
        dispatch(addDangerAlert(resp.message));
      },
    );
};

export const clearGlobalClusters = () => (dispatch) => dispatch({ type: CLEAR_GLOBAL_CLUSTERS });

const DEFAULT_GLOBAL_CLUSTERS_STATE = {
  loading: false,
  data: null,
  error: null,
};

export const globalClustersPageReducer = (state = DEFAULT_GLOBAL_CLUSTERS_STATE, action) => {
  switch (action.type) {
    case START_TO_LOAD_GLOBAL_CLUSTERS:
      return { loading: true, data: state.data, error: null };
    case FINISH_TO_LOAD_GLOBAL_CLUSTERS:
      return { loading: false, data: action.payload, error: null };
    case FAILED_TO_LOAD_GLOBAL_CLUSTERS:
      return { loading: false, data: null, error: action.payload };
    case CLEAR_GLOBAL_CLUSTERS:
      return DEFAULT_GLOBAL_CLUSTERS_STATE;
    default:
      return state;
  }
};
