import * as API from '../../../api/clusters';
import { addDangerAlert } from '../toaster';

const START_TO_RESOLVE_CLUSTER = 'START_TO_RESOLVE_CLUSTER';
const FINISH_TO_RESOLVE_CLUSTER = 'FINISH_TO_RESOLVE_CLUSTER';
const FAILED_TO_RESOLVE_CLUSTER = 'FAILED_TO_RESOLVE_CLUSTER';
const CLEAR_RESOLVED_CLUSTER = 'CLEAR_RESOLVED_CLUSTER';

export const resolveCluster = (cluster) => (dispatch) => {
  dispatch({ type: START_TO_RESOLVE_CLUSTER });

  return API.resolveCluster(cluster)
    .then(
      (resp) => dispatch({ type: FINISH_TO_RESOLVE_CLUSTER, payload: resp }),
      (resp) => {
        dispatch({ type: FAILED_TO_RESOLVE_CLUSTER, payload: resp });
        dispatch(addDangerAlert(resp.message));
      },
    );
};

export const clearResolvedCluster = () => (dispatch) => dispatch({ type: CLEAR_RESOLVED_CLUSTER });

const DEFAULT_RESOLVER_CLUSTER_STATE = {
  loading: false,
  data: null,
  error: null,
};

export const resolvedClusterReducer = (state = DEFAULT_RESOLVER_CLUSTER_STATE, action) => {
  switch (action.type) {
    case START_TO_RESOLVE_CLUSTER:
    case CLEAR_RESOLVED_CLUSTER:
      return { loading: true, data: null, error: null };
    case FINISH_TO_RESOLVE_CLUSTER:
      return { loading: false, data: action.payload, error: null };
    case FAILED_TO_RESOLVE_CLUSTER:
      return { loading: false, data: null, error: action.payload };
    default:
      return state;
  }
};
