import * as API from '../../../api/dashboards';
import { addDangerAlert } from '../toaster';

const DASHBOARD_FOUND = 'DASHBOARD_FOUND';
const DASHBOARD_SAVED = 'DASHBOARD_SAVED';
const DASHBOARD_DELETED = 'DASHBOARD_DELETED';
const DASHBOARD_CLEAR = 'DASHBOARD_CLEAR';

export const findDashboard = (projectId, dashboardId) => (dispatch) =>
  API.fetchDashboard(projectId, dashboardId)
    .then(
      (resp) => dispatch({ type: DASHBOARD_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const saveDashboard = (projectId, dashboard, isNew) => (dispatch) => {
  const promise = isNew
    ? API.createDashboard(projectId, dashboard)
    : API.updateDashboard(projectId, dashboard);
  promise.then(
    () => dispatch({ type: DASHBOARD_SAVED }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );
  return promise;
};

export const deleteDashboard = (projectId, dashboardId) => (dispatch) =>
  API.deleteDashboard(projectId, dashboardId)
    .then(
      () => dispatch({ type: DASHBOARD_DELETED }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearDashboard = () => ({
  type: DASHBOARD_CLEAR,
});

export const dashboardReducer = (state = {}, action) => {
  switch (action.type) {
    case DASHBOARD_FOUND:
      return action.payload;
    case DASHBOARD_SAVED:
    case DASHBOARD_DELETED:
    case DASHBOARD_CLEAR:
      return {};
    default:
      return state;
  }
};
