import * as API from '../../../api/dashboards';
import { addDangerAlert } from '../toaster';

const DASHBOARDS_FOUND = 'DASHBOARDS_FOUND';

export const findProjectDashboards = (projectId, params) => (dispatch) =>
  API.fetchProjectDashboards(projectId, params)
    .then(
      (resp) => dispatch({ type: DASHBOARDS_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const dashboardsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case DASHBOARDS_FOUND:
      return action.payload;
    default:
      return state;
  }
};
