import * as API from '../../../api/dashboards';
import { addDangerAlert } from '../toaster';

const GLOBAL_DASHBOARDS_FOUND = 'GLOBAL_DASHBOARDS_FOUND';

export const findAllDashboards = (params) => (dispatch) => API.fetchAllDashboards(params)
  .then(
    (resp) => dispatch({ type: GLOBAL_DASHBOARDS_FOUND, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const globalDashboardsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case GLOBAL_DASHBOARDS_FOUND:
      return action.payload;
    default:
      return state;
  }
};
