import * as API from '../../../api/data';

const START_TO_LOAD_DATA = 'START_TO_LOAD_DATA';
const FINISH_TO_LOAD_DATA = 'FINISH_TO_LOAD_DATA';
const FAILED_TO_LOAD_DATA = 'FAILED_TO_LOAD_DATA';
const CLEAR_DATA = 'CLEAR_DATA';

export const loadData = (projectId, params, useNewFormat) => (dispatch) => {
  dispatch({ type: START_TO_LOAD_DATA });

  return API.fetchSensorsData(projectId, params, useNewFormat)
    .then(
      (resp) => dispatch({ type: FINISH_TO_LOAD_DATA, payload: resp }),
      (resp) => dispatch({ type: FAILED_TO_LOAD_DATA, payload: resp.message }),
    );
};

export const clearData = () => (dispatch) => dispatch({ type: CLEAR_DATA });

const DEFAULT_DATA_STATE = { loading: false, error: null, data: {} };

export const sensorsDataReducer = (state = DEFAULT_DATA_STATE, action) => {
  switch (action.type) {
    case START_TO_LOAD_DATA:
      return { loading: true, error: null, data: state.data };
    case FINISH_TO_LOAD_DATA:
      return { loading: false, error: null, data: action.payload };
    case FAILED_TO_LOAD_DATA:
      return { loading: false, error: action.payload, data: {} };
    case CLEAR_DATA:
      return { loading: false, error: null, data: {} };
    default:
      return state;
  }
};
