import * as API from '../../../api/data';

const START_TO_LOAD_STOCKPILE_SENSOR = 'START_TO_LOAD_STOCKPILE_SENSOR';
const FINISH_TO_LOAD_STOCKPILE_SENSOR = 'FINISH_TO_LOAD_STOCKPILE_SENSOR';
const FAILED_TO_LOAD_STOCKPILE_SENSOR = 'FAILED_TO_LOAD_STOCKPILE_SENSOR';
const CLEAR_STOCKPILE_SENSOR = 'CLEAR_STOCKPILE_SENSOR';

export const loadStockpileSensorData = (projectId, params) => (dispatch) => {
  dispatch({ type: START_TO_LOAD_STOCKPILE_SENSOR });

  return API.fetchStockpileSensorData(projectId, params)
    .then(
      (resp) => dispatch({ type: FINISH_TO_LOAD_STOCKPILE_SENSOR, payload: resp }),
      (resp) => dispatch({
        type: FAILED_TO_LOAD_STOCKPILE_SENSOR,
        payload: resp.message,
      }),
    );
};

export const clearStockpileSensorData = () => (dispatch) =>
  dispatch({ type: CLEAR_STOCKPILE_SENSOR });

const DEFAULT_STOCKPILE_SENSOR_DATA = { loading: false, error: null, data: {} };

export const stockpileSensorDataReducer = (state = DEFAULT_STOCKPILE_SENSOR_DATA, action) => {
  switch (action.type) {
    case START_TO_LOAD_STOCKPILE_SENSOR:
      return { loading: true, error: null, data: state.data };
    case FINISH_TO_LOAD_STOCKPILE_SENSOR:
      return { loading: false, error: null, data: action.payload };
    case FAILED_TO_LOAD_STOCKPILE_SENSOR:
      return { loading: false, error: action.payload, data: {} };
    case CLEAR_STOCKPILE_SENSOR:
      return DEFAULT_STOCKPILE_SENSOR_DATA;
    default:
      return state;
  }
};
