import * as API from '../../../api/graphs';
import { addDangerAlert } from '../toaster';

const GLOBAL_GRAPHS_FOUND = 'GLOBAL_GRAPHS_FOUND';

export const findAllGraphs = (params) => (dispatch) => API.fetchAllGraphs(params)
  .then(
    (resp) => dispatch({ type: GLOBAL_GRAPHS_FOUND, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const globalGraphsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case GLOBAL_GRAPHS_FOUND:
      return action.payload;
    default:
      return state;
  }
};
