import * as API from '../../../api/graphs';
import { addDangerAlert } from '../toaster';

const GRAPH_FOUND = 'GRAPH_FOUND';
const GRAPH_SAVED = 'GRAPH_SAVED';
const GRAPH_DELETED = 'GRAPH_DELETED';
const GRAPH_CLEAR = 'GRAPH_CLEAR';

export const findGraph = (projectId, graphId) => (dispatch) => API.fetchGraph(projectId, graphId)
  .then(
    (resp) => dispatch({ type: GRAPH_FOUND, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const setGraph = (body) => (dispatch) => dispatch({ type: GRAPH_FOUND, payload: body });

export const saveGraph = (projectId, graph, isNew) => (dispatch) => {
  const promise = isNew
    ? API.createGraph(projectId, graph)
    : API.updateGraph(projectId, graph);
  promise.then(
    () => dispatch({ type: GRAPH_SAVED }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );
  return promise;
};

export const deleteGraph = (projectId, graphId) => (dispatch) => API.deleteGraph(projectId, graphId)
  .then(
    () => dispatch({ type: GRAPH_DELETED }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const clearGraph = () => ({
  type: GRAPH_CLEAR,
});

export const graphReducer = (state = {}, action) => {
  switch (action.type) {
    case GRAPH_FOUND:
      return action.payload;
    case GRAPH_SAVED:
    case GRAPH_DELETED:
    case GRAPH_CLEAR:
      return {};
    default:
      return state;
  }
};
