import * as API from '../../../api/graphs';
import { addDangerAlert } from '../toaster';

const GRAPHS_FOUND = 'GRAPHS_FOUND';

export const findProjectGraphs = (projectId, params) => (dispatch) =>
  API.fetchProjectGraphs(projectId, params)
    .then(
      (resp) => dispatch({ type: GRAPHS_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const graphsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case GRAPHS_FOUND:
      return action.payload;
    default:
      return state;
  }
};
