import { combineReducers } from 'redux';
import { infraBuzzer } from '@yandex-data-ui/infra-buzzer';

import { alertsReducer } from './toaster';
import serviceReducers from './services';
import clusterReducers from './clusters';
import shardReducers from './shards';
import projectReducers from './projects';
import dashboardReducers from './dashboards';
import graphReducers from './graphs';
import sensorReducers from './sensors';
import alertReducers from './alerts';
import channelReducers from './channels';
import mutesReducers from './mutes';
import paramSensorsReducers from './paramSensors';
import dataReducers from './data';
import oldReducers from './old';
import otherReducers from './others';
import serviceProviderReducers from './serviceProviders';

const appReducer = combineReducers({
  ...serviceReducers,
  ...clusterReducers,
  ...shardReducers,
  ...projectReducers,
  ...dashboardReducers,
  ...graphReducers,
  ...sensorReducers,
  ...alertReducers,
  ...channelReducers,
  ...mutesReducers,
  ...paramSensorsReducers,
  ...dataReducers,
  ...oldReducers,
  ...serviceProviderReducers,
  ...otherReducers,
  alerts: alertsReducer,
  infraBuzzer,
});

export default appReducer;
