import * as API from '../../../api/alerts';
import { addDangerAlert } from '../toaster';

const LOAD_MUTE_ALERTS = 'LOAD_MUTE_ALERTS';
const LOAD_NEXT_MUTE_ALERTS = 'LOAD_NEXT_MUTE_ALERTS';
const CLEAR_MUTE_ALERTS = 'CLEAR_MUTE_ALERTS';

export const loadMuteAlerts = (projectId, muteId, params) => (dispatch) =>
  API.fetchAlerts(projectId, { filterByMuteId: muteId, ...params })
    .then(
      (resp) => dispatch({ type: LOAD_MUTE_ALERTS, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const loadNextMuteAlerts = (projectId, muteId, params) => (dispatch) =>
  API.fetchAlerts(projectId, { filterByMuteId: muteId, ...params })
    .then(
      (resp) => dispatch({ type: LOAD_NEXT_MUTE_ALERTS, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearMuteAlerts = () => (dispatch) => dispatch({ type: CLEAR_MUTE_ALERTS });

export const muteAlertsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_MUTE_ALERTS:
      return action.payload;
    case LOAD_NEXT_MUTE_ALERTS:
      return { ...action.payload, items: [...state.items, ...action.payload.items] };
    case CLEAR_MUTE_ALERTS:
      return {};
    default:
      return state;
  }
};
