import * as API from '../../../api/mutes';
import { addDangerAlert } from '../toaster';

const START_TO_EXPLAIN_MUTE = 'START_TO EXPLAIN_MUTE';
const FINISH_TO_EXPLAIN_MUTE = 'FINISH_TO EXPLAIN_MUTE';
const CLEAR_MUTE_EXPLANATION = 'CLEAR_MUTE_EXPLANATION';

export const explainMute = (projectId, mute, params) => (dispatch) => {
  dispatch({ type: START_TO_EXPLAIN_MUTE });

  return API.explainMute(projectId, mute, params)
    .then((resp) => dispatch({
      type: FINISH_TO_EXPLAIN_MUTE,
      payload: resp,
    }),
    (resp) => dispatch(addDangerAlert(resp.message)));
};

export const loadNextMuteExplanation = (projectId, mute, params) => (dispatch) =>
  API.explainMute(projectId, mute, ...params)
    .then(
      (resp) => dispatch({ type: FINISH_TO_EXPLAIN_MUTE, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

// eslint-disable-next-line max-len
export const clearMuteExplanation = () => (dispatch) => dispatch({ type: CLEAR_MUTE_EXPLANATION });

const DEFAULT_STATE = {};

const MUTE_EXPLANATION_LOADING_STATE = {
  loading: true,
  data: null,
};

export const muteExplanationReducer = (state = DEFAULT_STATE, action) => {
  switch (action.type) {
    case START_TO_EXPLAIN_MUTE:
      return MUTE_EXPLANATION_LOADING_STATE;
    case FINISH_TO_EXPLAIN_MUTE:
      return { loading: false, data: action.payload };
    case CLEAR_MUTE_EXPLANATION:
      return DEFAULT_STATE;
    default:
      return state;
  }
};
