import * as API from '../../../api/mutes';
import { addDangerAlert } from '../toaster';

export const MUTE_FOUND = 'MUTE_FOUND';
const MUTE_SAVED = 'MUTE_SAVED';
const MUTE_DELETED = 'MUTE_DELETED';
const MUTE_CLEAR = 'MUTE_CLEAR';

export const findMute = (projectId, muteId) => (dispatch) =>
  API.fetchMute(projectId, muteId)
    .then(
      (resp) => dispatch({ type: MUTE_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const saveMute = (projectId, mute, isNew) => (dispatch) => {
  const promise = isNew
    ? API.createMute(projectId, mute)
    : API.updateMute(projectId, mute);
  promise.then(
    () => dispatch({ type: MUTE_SAVED }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );
  return promise;
};

export const deleteMute = (projectId, muteId) => (dispatch) =>
  API.deleteMute(projectId, muteId)
    .then(
      () => dispatch({ type: MUTE_DELETED }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearMute = () => ({
  type: MUTE_CLEAR,
});

export const muteReducer = (state = {}, action) => {
  switch (action.type) {
    case MUTE_FOUND:
      return action.payload;
    case MUTE_SAVED:
    case MUTE_DELETED:
    case MUTE_CLEAR:
      return {};
    default:
      return state;
  }
};
