import * as API from '../../../api/mutes';
import { addDangerAlert } from '../toaster';

const LOAD_PROJECT_MUTES = 'LOAD_PROJECT_MUTES';
const LOAD_NEXT_PROJECT_MUTES = 'LOAD_NEXT_PROJECT_MUTES';
const CLEAR_PROJECT_MUTES = 'CLEAR_PROJECT_MUTES';

export const loadProjectMutes = (projectId, params) => (dispatch) =>
  API.fetchProjectMutes(projectId, params)
    .then(
      (resp) => dispatch({ type: LOAD_PROJECT_MUTES, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const loadNextProjectMutes = (projectId, params) => (dispatch) =>
  API.fetchProjectMutes(projectId, params)
    .then(
      (resp) => dispatch({ type: LOAD_NEXT_PROJECT_MUTES, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearProjectMutes = () => (dispatch) => dispatch({ type: CLEAR_PROJECT_MUTES });

export const mutesPageReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_PROJECT_MUTES:
      return action.payload;
    case LOAD_NEXT_PROJECT_MUTES:
      return { ...action.payload, items: [...state.items, ...action.payload.items] };
    case CLEAR_PROJECT_MUTES:
      return {};
    default:
      return state;
  }
};
