import * as API from '../../../api/mutes';

const LOAD_PROJECT_MUTES_STATS = 'LOAD_PROJECT_MUTES_STATS';
const CLEAR_PROJECT_MUTES_STATS = 'CLEAR_PROJECT_MUTES_STATS';

export const loadProjectMutesStats = (projectId) => (dispatch) =>
  API.fetchProjectMutesStats(projectId)
    .then(
      (resp) => dispatch({ type: LOAD_PROJECT_MUTES_STATS, payload: resp }),
      () => dispatch({ type: LOAD_PROJECT_MUTES_STATS, payload: {} }),
    );

export const clearProjectMutesStats = () => (dispatch) =>
  dispatch({ type: CLEAR_PROJECT_MUTES_STATS });

export const projectMutesStatsReducer = (state = {}, action) => {
  switch (action.type) {
    case LOAD_PROJECT_MUTES_STATS:
      return action.payload;
    case CLEAR_PROJECT_MUTES_STATS:
      return {};
    default:
      return state;
  }
};
