/* Action creators */
import { fetchLabelNames } from '../../../api/sensors';

const SHOW_LABELS_DROPDOWN = 'lastPlusSelector/SHOW_LABELS_DROPDOWN';
const LOAD_LABEL_KEYS = 'lastPlusSelector/LOAD_LABEL_KEYS';
const RESET_LABELS_DROPDOWN = 'lastPlusSelector/RESET_LABELS_DROPDOWN';
const CHANGE_LABEL_FILTER = 'lastPlusSelector/CHANGE_LABEL_FILTER';
const SELECT_LABEL = 'lastPlusSelector/SELECT_LABEL';

export const showLabelsDropdown = (projectId, selectors) => (dispatch) => {
  dispatch({ type: SHOW_LABELS_DROPDOWN });

  fetchLabelNames(projectId, { selectors }).then((response) => dispatch({ type: LOAD_LABEL_KEYS, payload: { labels: response.names || [], filter: '' } }));
};

export const hideLabelsDropdown = () => (dispatch) => dispatch({ type: RESET_LABELS_DROPDOWN });

export const changeLabelFilter = (projectId, selectors, filter) => (dispatch) => {
  dispatch({ type: CHANGE_LABEL_FILTER, payload: filter });

  fetchLabelNames(projectId, { selectors })
    .then((response) => dispatch({
      type: LOAD_LABEL_KEYS,
      payload: { labels: response.names || [], filter },
    }));
};

export const selectLabel = (selector) => (dispatch) =>
  dispatch({ type: SELECT_LABEL, payload: selector });

// Reducers

const DEFAULT_STATE = {
  type: 'none',
  selector: null,
  labelFilter: '',
  labelOptions: [],
};

export const oldLastPlusSelectorReducer = (state = DEFAULT_STATE, action) => {
  switch (action.type) {
    case SHOW_LABELS_DROPDOWN:
      return {
        type: 'key',
        selector: null,
        labelFilter: '',
        labelOptions: [],
      };
    case RESET_LABELS_DROPDOWN:
      return DEFAULT_STATE;
    case CHANGE_LABEL_FILTER:
      return {
        ...state,
        labelFilter: action.payload,
      };
    case LOAD_LABEL_KEYS: {
      const { labels, filter } = action.payload;
      if (filter !== state.labelFilter) {
        return state;
      }
      const filteredLabels = filter ? labels.filter((l) => l.indexOf(filter) >= 0) : labels;

      const options = filteredLabels.map((l) => ({ content: l, value: l }));

      return {
        ...state,
        labelOptions: options,
      };
    }
    case SELECT_LABEL:
      return {
        type: 'value',
        selector: action.payload,
        labelFilter: '',
        labelOptions: [],
      };
    default:
      return state;
  }
};
