import * as API from '../../../api/internal';
import { addDangerAlert } from '../toaster';

export const USER_PIN_DELETED_FOR_PAGE = 'USER_PIN_DELETED';
export const USER_PIN_CREATED = 'USER_PIN_CREATED';
export const USER_PINS_FOUND = 'USER_PINS_FOUND';

export const getPins = (params) => (dispatch) => API.getPinsByUrl(params)
  .then(
    (resp) => dispatch({ type: USER_PINS_FOUND, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const createPin = (params) => (dispatch) => API.createPin(params)
  .then(
    (resp) => dispatch({ type: USER_PIN_CREATED, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const deletePin = (id) => (dispatch) => API.deletePin(id)
  .then(
    () => dispatch({ type: USER_PIN_DELETED_FOR_PAGE }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const userPinsReducer = (state = [], action) => {
  switch (action.type) {
    case USER_PINS_FOUND:
      return action.payload;
    default:
      return state;
  }
};
